<?php

/* -----------------------------------------------------------------
 * 	$Id: google.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Google {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;
    var $v_categorie_file_path;

    function Google() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Google Mercant Center';
        $this->v_module_homepage = 'www.google.de/products';
        $this->v_module_format = 'txt';
        $this->v_module_export_filename = 'google.txt';
        $this->v_filename = 'google.php';
        $this->v_keyname = 'GOOGLE';
        $this->v_linkname = 'google';
        $this->v_delimiter = "\t";
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;

        $this->v_categorie_file_path = 'http://www.google.com/basepages/producttype/taxonomy.de-DE.txt';
    }

    function formAddOn() {
        $t_query = "SELECT configuration_value FROM configuration WHERE configuration_key = 'PRODUCT_GOOGLE_STANDARD_TAXONOMIE_PATH'";
        $t_result = xtc_db_query($t_query);
        $t_setup = xtc_db_fetch_array($t_result);

        $t_addOns = '<tr style="vertical-align:top; background-color:#d6e6f3;">
				   <td class="dataTableContent"><b>Google Kategorie URL</b></td>
				   <td class="dataTableContent">' . xtc_draw_input_field('categorie_file_path', $t_setup['configuration_value'], 'style="width: 450px;"')
                . '<br />Geben Sie hier den Pfad zur Taxonomy Datei f&uuml;r die Google Produkt-Kategorien an.';

        // return addon setup
        return($t_addOns);
    }

    function formatResults($p_products_array) {
        $p_products_array['products_condition'] = 'neu';
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = ':::' . number_format((double) $p_products_array['products_shipping_costs'], 2, '.', '');
        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));
        if (!empty($p_products_array['products_description']) && strlen($p_products_array['products_description']) > 1500) {
            $desc = $p_products_array['products_description'];
            $length = strpos($desc, " ", 1500);
            $p_products_array['products_description'] = substr($p_products_array['products_description'], 0, $length) . '[...]';
        }
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_description'] = 'beschreibung';
        $t_csv_fields_array['products_id'] = 'id';
        $t_csv_fields_array['products_link'] = 'link';
        $t_csv_fields_array['products_price'] = 'preis';
        $t_csv_fields_array['products_name'] = 'titel';
        $t_csv_fields_array['products_condition'] = 'zustand';
        $t_csv_fields_array['products_image_1'] = 'bild_url';
        $t_csv_fields_array['products_ean'] = 'ean';
        $t_csv_fields_array['products_weight'] = 'gewicht';
        $t_csv_fields_array['manufacturers_name'] = 'marke';
        $t_csv_fields_array['products_shipping_costs'] = 'versand';
        $t_csv_fields_array['products_isbn'] = 'isbn';
        $t_csv_fields_array['products_model'] = 'mpn';
        return($t_csv_fields_array);
    }

}

?>